<?php
/**
 * Autoloader zgodny z PEAR/Zend Framework
 * 
 * 
 * Ten autoloader zamienia znaki podkreślenia
 * na znaki podkatalogów.
 * 
 * @param string $classname Klasa, która ma być dołączona
 * @return bool
 */
function MyAutoloader($classname)
{
  // Zamienia znaki _ na ukośniki odpowiedni dla danego systemu operacyjnego i dodaje .php
  $path = str_replace('_', DIRECTORY_SEPARATOR, $classname) . '.php';
  // Dołącza plik i tłumi wyświetlanie błędów za pomocą operatora @
  // Ponieważ wynik jest poprawny, nastąpi przejście do
  // następnego loadera w stosie.
  $result = @include($classname);
  
  // Zwraca wartość logiczną
  return $result;
}
// Jeśli mamy już funkcję __autoload to ją rejestrujemy, a jeśli tego nie zrobimy 
// SPL ją przesłoni.
if (function_exists('__autoload')) {
  spl_autoload_register('__autoload');
}
// Rejestracja naszego autoloadera
spl_autoload_register('MyAutoloader');
$obj = new Nazwa_Jakiejś_Klasy(); // Dołącza Nazwa/Jakiejś/Klasy.php
